import { View, Text, Pressable, FlatList } from "react-native";
import React from "react";
import { useNavigation } from "@react-navigation/native";
import { ratingAndReviewsStyle } from "../RatingAndReviewsStyle";
import ReviewImages from "../ReviewImages";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";

const SingleReviewImages = ({ images }) => {
    const {trans} = useLangTranslation()
    const navigation = useNavigation();
    return (
        <View style={ratingAndReviewsStyle.reviewImgCont}>
            <View style={ratingAndReviewsStyle.reviewImgCont}>
                {images?.length > 5 && (
                    <Pressable
                        style={ratingAndReviewsStyle.imageSeeAll}
                        onPress={() =>
                            navigation.navigate("reviewImageGallery", {
                                images,
                            })
                        }
                    >
                        <Text style={ratingAndReviewsStyle.imageSeeAllText}>
                            {trans("See All")}
                        </Text>
                    </Pressable>
                )}
                <FlatList
                    data={images}
                    keyExtractor={(_, index) => "key" + index}
                    renderItem={(image) => (
                        <ReviewImages
                            image={image.item}
                            index={image.index}
                            data={images}
                            imageStyle={ratingAndReviewsStyle.reviewImg}
                        />
                    )}
                    horizontal
                    scrollEnabled={false}
                    showsHorizontalScrollIndicator={false}
                />
            </View>
        </View>
    );
};

export default SingleReviewImages;
